/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.PacketBuffer;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.internal.EntitySpawnMessageHelper;
import net.minecraftforge.fml.common.network.internal.FMLMessage;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;
import noppes.npcs.CustomNpcs;
import noppes.npcs.LogWriter;
import noppes.npcs.constants.EnumPacketClient;
import noppes.npcs.dimensions.CustomWorldInfo;
import noppes.npcs.reflection.pathfinding.PathReflection;
import noppes.npcs.util.CustomNPCsScheduler;
import noppes.npcs.util.Util;

public class Server {
    private static List<EnumPacketClient> list = new ArrayList<EnumPacketClient>();

    public static boolean fillBuffer(ByteBuf buffer, Enum<?> type, Object ... obs) throws Exception {
        buffer.writeInt(type.ordinal());
        for (Object ob : obs) {
            if (ob == null) continue;
            if (ob instanceof Map) {
                Map map = (Map)ob;
                buffer.writeInt(map.size());
                int i = 0;
                for (Map.Entry entry : map.entrySet()) {
                    NBTBase key = Util.instance.writeObjectToNbt(entry.getKey());
                    NBTBase value = Util.instance.writeObjectToNbt(entry.getValue());
                    if (key != null && key.func_74732_a() < 9 && key.func_74732_a() != 7) {
                        buffer.writeByte((int)key.func_74732_a());
                        switch (key.func_74732_a()) {
                            case 0: {
                                buffer.writeByte(0);
                                break;
                            }
                            case 1: {
                                buffer.writeByte((int)((NBTTagByte)key).func_150290_f());
                                break;
                            }
                            case 2: {
                                buffer.writeShort((int)((NBTTagShort)key).func_150289_e());
                                break;
                            }
                            case 3: {
                                buffer.writeInt(((NBTTagInt)key).func_150287_d());
                                break;
                            }
                            case 4: {
                                buffer.writeLong(((NBTTagLong)key).func_150291_c());
                                break;
                            }
                            case 5: {
                                buffer.writeFloat(((NBTTagFloat)key).func_150288_h());
                                break;
                            }
                            case 6: {
                                buffer.writeDouble(((NBTTagDouble)key).func_150286_g());
                                break;
                            }
                            case 8: {
                                Server.writeString(buffer, ((NBTTagString)key).func_150285_a_());
                                break;
                            }
                            default: {
                                Server.writeString(buffer, "unknown_key_" + i);
                                break;
                            }
                        }
                    } else {
                        buffer.writeByte(16);
                        Server.writeString(buffer, "unknown_key_" + i);
                    }
                    if (value != null && value.func_74732_a() < 9 && value.func_74732_a() != 7) {
                        buffer.writeByte((int)value.func_74732_a());
                        switch (value.func_74732_a()) {
                            case 0: {
                                buffer.writeByte(0);
                                break;
                            }
                            case 1: {
                                buffer.writeByte((int)((NBTTagByte)value).func_150290_f());
                                break;
                            }
                            case 2: {
                                buffer.writeShort((int)((NBTTagShort)value).func_150289_e());
                                break;
                            }
                            case 3: {
                                buffer.writeInt(((NBTTagInt)value).func_150287_d());
                                break;
                            }
                            case 4: {
                                buffer.writeLong(((NBTTagLong)value).func_150291_c());
                                break;
                            }
                            case 5: {
                                buffer.writeFloat(((NBTTagFloat)value).func_150288_h());
                                break;
                            }
                            case 6: {
                                buffer.writeDouble(((NBTTagDouble)value).func_150286_g());
                                break;
                            }
                            case 8: {
                                Server.writeString(buffer, ((NBTTagString)value).func_150285_a_());
                                break;
                            }
                            default: {
                                Server.writeString(buffer, "unknown_value_" + i);
                                break;
                            }
                        }
                    } else {
                        buffer.writeByte(16);
                        Server.writeString(buffer, "unknown_value_" + i);
                    }
                    ++i;
                }
                continue;
            }
            if (ob instanceof MerchantRecipeList) {
                ((MerchantRecipeList)ob).func_151391_a(new PacketBuffer(buffer));
                continue;
            }
            if (ob instanceof List) {
                try {
                    List list = (List)ob;
                    buffer.writeInt(list.size());
                    for (String s : list) {
                        Server.writeString(buffer, s);
                    }
                    continue;
                }
                catch (Exception ignore) {
                    try {
                        List list = (List)ob;
                        int[] a = new int[list.size()];
                        int j = 0;
                        Iterator iterator = list.iterator();
                        while (iterator.hasNext()) {
                            int i;
                            a[j] = i = ((Integer)iterator.next()).intValue();
                            ++j;
                        }
                        Server.writeIntArray(buffer, a);
                    }
                    catch (Exception exception) {}
                    continue;
                }
            }
            if (ob instanceof UUID) {
                Server.writeString(buffer, ob.toString());
                continue;
            }
            if (ob instanceof Enum) {
                buffer.writeInt(((Enum)ob).ordinal());
                continue;
            }
            if (ob instanceof Integer) {
                buffer.writeInt(((Integer)ob).intValue());
                continue;
            }
            if (ob instanceof Boolean) {
                buffer.writeBoolean(((Boolean)ob).booleanValue());
                continue;
            }
            if (ob instanceof String) {
                Server.writeString(buffer, (String)ob);
                continue;
            }
            if (ob instanceof ResourceLocation) {
                Server.writeString(buffer, ((ResourceLocation)ob).toString());
                continue;
            }
            if (ob instanceof Float) {
                buffer.writeFloat(((Float)ob).floatValue());
                continue;
            }
            if (ob instanceof Long) {
                buffer.writeLong(((Long)ob).longValue());
                continue;
            }
            if (ob instanceof Double) {
                buffer.writeDouble(((Double)ob).doubleValue());
                continue;
            }
            if (ob instanceof NBTTagCompound) {
                Server.writeNBT(buffer, (NBTTagCompound)ob);
                continue;
            }
            if (ob instanceof FMLMessage.EntitySpawnMessage) {
                EntitySpawnMessageHelper.toBytes((FMLMessage.EntitySpawnMessage)ob, buffer);
                continue;
            }
            if (ob instanceof Integer[] || ob instanceof int[]) {
                assert (ob instanceof int[]);
                Server.writeIntArray(buffer, (int[])ob);
                continue;
            }
            if (!(ob instanceof WorldInfo)) continue;
            Server.writeWorldInfo(buffer, (WorldInfo)ob);
        }
        if (buffer.array().length > 32768) {
            throw new RuntimeException("Packet " + type + " was too big to be send [" + buffer.array().length + "/32768]");
        }
        return true;
    }

    public static int[] readIntArray(ByteBuf buffer) {
        int[] a = new int[buffer.readInt()];
        for (int i = 0; i < a.length; ++i) {
            a[i] = buffer.readInt();
        }
        return a;
    }

    public static Map<Object, Object> readMap(ByteBuf buffer) {
        LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>();
        int size = buffer.readInt();
        for (int i = 0; i < size; ++i) {
            Object value;
            Object key;
            switch (buffer.readByte()) {
                case 0: 
                case 1: {
                    key = buffer.readByte();
                    break;
                }
                case 2: {
                    key = buffer.readShort();
                    break;
                }
                case 3: {
                    key = buffer.readInt();
                    break;
                }
                case 4: {
                    key = buffer.readLong();
                    break;
                }
                case 5: {
                    key = Float.valueOf(buffer.readFloat());
                    break;
                }
                case 6: {
                    key = buffer.readDouble();
                    break;
                }
                default: {
                    key = Server.readString(buffer);
                }
            }
            switch (buffer.readByte()) {
                case 0: 
                case 1: {
                    value = buffer.readByte();
                    break;
                }
                case 2: {
                    value = buffer.readShort();
                    break;
                }
                case 3: {
                    value = buffer.readInt();
                    break;
                }
                case 4: {
                    value = buffer.readLong();
                    break;
                }
                case 5: {
                    value = Float.valueOf(buffer.readFloat());
                    break;
                }
                case 6: {
                    value = buffer.readDouble();
                    break;
                }
                default: {
                    value = Server.readString(buffer);
                }
            }
            map.put(key, value);
        }
        return map;
    }

    public static NBTTagCompound readNBT(ByteBuf buffer) throws IOException {
        byte[] bytes = new byte[buffer.readInt()];
        buffer.readBytes(bytes);
        try (DataInputStream datainputstream = new DataInputStream(new BufferedInputStream(new GZIPInputStream(new ByteArrayInputStream(bytes))));){
            NBTTagCompound nBTTagCompound = CompressedStreamTools.func_152456_a((DataInput)datainputstream, (NBTSizeTracker)NBTSizeTracker.field_152451_a);
            return nBTTagCompound;
        }
    }

    private static PathPoint readPathPoint(NBTTagCompound nbt) {
        PathPoint point = new PathPoint(nbt.func_74762_e("x"), nbt.func_74762_e("y"), nbt.func_74762_e("z"));
        point.field_186284_j = nbt.func_74760_g("dfo");
        point.field_186285_k = nbt.func_74760_g("c");
        point.field_186286_l = nbt.func_74760_g("cm");
        point.field_75842_i = nbt.func_74767_n("dfo");
        point.field_186287_m = PathNodeType.values()[nbt.func_74762_e("nt")];
        point.field_75834_g = nbt.func_74760_g("d");
        return point;
    }

    public static Path readPathToNBT(NBTTagCompound nbt) {
        int i;
        PathPoint[] points = new PathPoint[nbt.func_150295_c("ps", 10).func_74745_c()];
        PathPoint[] openSet = new PathPoint[nbt.func_150295_c("op", 10).func_74745_c()];
        PathPoint[] closedSet = new PathPoint[nbt.func_150295_c("cp", 10).func_74745_c()];
        for (i = 0; i < nbt.func_150295_c("ps", 10).func_74745_c(); ++i) {
            points[i] = Server.readPathPoint(nbt.func_150295_c("ps", 10).func_150305_b(i));
        }
        for (i = 0; i < nbt.func_150295_c("op", 10).func_74745_c(); ++i) {
            openSet[i] = Server.readPathPoint(nbt.func_150295_c("op", 10).func_150305_b(i));
        }
        for (i = 0; i < nbt.func_150295_c("cp", 10).func_74745_c(); ++i) {
            closedSet[i] = Server.readPathPoint(nbt.func_150295_c("cp", 10).func_150305_b(i));
        }
        Path navigating = new Path(points);
        PathReflection.setOpenSet(navigating, openSet);
        PathReflection.setClosedSet(navigating, closedSet);
        PathReflection.setCurrentPathIndex(navigating, nbt.func_74762_e("ci"));
        return navigating;
    }

    public static String readString(ByteBuf buffer) {
        try {
            byte[] bytes = new byte[buffer.readInt()];
            buffer.readBytes(bytes);
            return new String(bytes, StandardCharsets.UTF_8);
        }
        catch (IndexOutOfBoundsException ex) {
            return null;
        }
    }

    public static UUID readUUID(ByteBuf buffer) {
        return UUID.fromString(Objects.requireNonNull(Server.readString(buffer)));
    }

    public static CustomWorldInfo readWorldInfo(ByteBuf buffer) {
        return new CustomWorldInfo(ByteBufUtils.readTag((ByteBuf)buffer));
    }

    public static void sendAssociatedData(Entity entity, EnumPacketClient type, Object ... obs) {
        List<EntityPlayerMP> list = Util.instance.getEntitiesWithinDist(EntityPlayerMP.class, entity.field_70170_p, entity, 160.0);
        if (list.isEmpty()) {
            return;
        }
        ByteBuf buffer = Unpooled.buffer();
        try {
            if (Server.fillBuffer(buffer, type, obs)) {
                if (!Server.list.contains((Object)type)) {
                    LogWriter.debug("SendAssociatedData: " + (Object)((Object)type));
                }
                for (EntityPlayerMP entityPlayerMP : list) {
                    CustomNpcs.Channel.sendTo(new FMLProxyPacket(new PacketBuffer(buffer.copy()), "CustomNpcs"), entityPlayerMP);
                }
            }
        }
        catch (Exception e) {
            LogWriter.error("Error send data:", e);
        }
    }

    public static void sendData(EntityPlayerMP player, EnumPacketClient type, Object ... obs) {
        ByteBuf buffer = Unpooled.buffer();
        try {
            if (Server.fillBuffer(buffer, type, obs)) {
                if (!list.contains((Object)type)) {
                    LogWriter.debug("SendAssociatedData: " + (Object)((Object)type));
                }
                CustomNpcs.Channel.sendTo(new FMLProxyPacket(new PacketBuffer(buffer.copy()), "CustomNpcs"), player);
            }
        }
        catch (Exception e) {
            LogWriter.error("Error send data:", e);
        }
    }

    public static boolean sendDataChecked(EntityPlayerMP player, EnumPacketClient type, Object ... obs) {
        PacketBuffer buffer = new PacketBuffer(Unpooled.buffer());
        try {
            if (!Server.fillBuffer((ByteBuf)buffer, type, obs)) {
                return false;
            }
            if (!list.contains((Object)type)) {
                LogWriter.debug("SendDataChecked: " + (Object)((Object)type));
            }
            CustomNpcs.Channel.sendTo(new FMLProxyPacket(buffer, "CustomNpcs"), player);
        }
        catch (Exception e) {
            LogWriter.error("Error send data:", e);
        }
        return true;
    }

    public static void sendDataDelayed(EntityPlayerMP player, EnumPacketClient type, int delay, Object ... obs) {
        CustomNPCsScheduler.runTack(() -> {
            PacketBuffer buffer = new PacketBuffer(Unpooled.buffer());
            try {
                if (Server.fillBuffer((ByteBuf)buffer, type, obs)) {
                    if (!list.contains((Object)type)) {
                        LogWriter.debug("SendData: " + (Object)((Object)type));
                    }
                    CustomNpcs.Channel.sendTo(new FMLProxyPacket(buffer, "CustomNpcs"), player);
                } else {
                    LogWriter.error("Not Send: " + (Object)((Object)type));
                }
            }
            catch (Exception e) {
                LogWriter.error("Error send data:", e);
            }
        }, delay);
    }

    public static void sendRangedData(Entity entity, int range, EnumPacketClient type, Object ... obs) {
        List<EntityPlayerMP> list = Util.instance.getEntitiesWithinDist(EntityPlayerMP.class, entity.field_70170_p, entity, (double)range);
        if (list.isEmpty()) {
            return;
        }
        ByteBuf buffer = Unpooled.buffer();
        try {
            if (Server.fillBuffer(buffer, type, obs)) {
                if (!Server.list.contains((Object)type)) {
                    LogWriter.debug("SendRangedData: " + (Object)((Object)type));
                }
                for (EntityPlayerMP entityPlayerMP : list) {
                    CustomNpcs.Channel.sendTo(new FMLProxyPacket(new PacketBuffer(buffer.copy()), "CustomNpcs"), entityPlayerMP);
                }
            }
        }
        catch (Exception e) {
            LogWriter.error("Error send data:", e);
        }
    }

    public static void sendRangedData(World world, BlockPos pos, int range, EnumPacketClient type, Object ... obs) {
        List<EntityPlayerMP> list = Util.instance.getEntitiesWithinDist(EntityPlayerMP.class, world, pos, (double)range);
        if (list.isEmpty()) {
            return;
        }
        ByteBuf buffer = Unpooled.buffer();
        try {
            if (Server.fillBuffer(buffer, type, obs)) {
                if (!Server.list.contains((Object)type)) {
                    LogWriter.debug("SendRangedData: " + (Object)((Object)type));
                }
                for (EntityPlayerMP entityPlayerMP : list) {
                    CustomNpcs.Channel.sendTo(new FMLProxyPacket(new PacketBuffer(buffer.copy()), "CustomNpcs"), entityPlayerMP);
                }
            }
        }
        catch (Exception e) {
            LogWriter.error("Error send data:", e);
        }
    }

    public static void sendToAll(MinecraftServer server, EnumPacketClient type, Object ... obs) {
        if (server == null) {
            return;
        }
        ArrayList list = new ArrayList(server.func_184103_al().func_181057_v());
        ByteBuf buffer = Unpooled.buffer();
        try {
            if (Server.fillBuffer(buffer, type, obs)) {
                if (!Server.list.contains((Object)type)) {
                    LogWriter.debug("SendToAll: " + (Object)((Object)type));
                }
                for (EntityPlayerMP entityPlayerMP : list) {
                    CustomNpcs.Channel.sendTo(new FMLProxyPacket(new PacketBuffer(buffer.copy()), "CustomNpcs"), entityPlayerMP);
                }
            }
        }
        catch (Exception e) {
            LogWriter.error("Error send data:", e);
        }
    }

    public static void writeIntArray(ByteBuf buffer, int[] a) {
        buffer.writeInt(a.length);
        for (int i : a) {
            buffer.writeInt(i);
        }
    }

    public static void writeNBT(ByteBuf buffer, NBTTagCompound compound) throws IOException {
        ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
        try (DataOutputStream dataoutputstream = new DataOutputStream(new GZIPOutputStream(bytearrayoutputstream));){
            CompressedStreamTools.func_74800_a((NBTTagCompound)compound, (DataOutput)dataoutputstream);
        }
        byte[] bytes = bytearrayoutputstream.toByteArray();
        buffer.writeInt(bytes.length);
        buffer.writeBytes(bytes);
    }

    private static NBTTagCompound writePathPoint(PathPoint point) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("x", point.field_75839_a);
        nbt.func_74768_a("y", point.field_75837_b);
        nbt.func_74768_a("z", point.field_75838_c);
        nbt.func_74776_a("dfo", point.field_186284_j);
        nbt.func_74776_a("c", point.field_186285_k);
        nbt.func_74776_a("cm", point.field_186286_l);
        nbt.func_74776_a("d", point.field_75834_g);
        nbt.func_74757_a("dfo", point.field_75842_i);
        nbt.func_74768_a("nt", point.field_186287_m.ordinal());
        return nbt;
    }

    public static NBTTagCompound writePathToNBT(Path path) {
        NBTTagCompound nbt = new NBTTagCompound();
        PathPoint[] points = PathReflection.getPoints(path);
        PathPoint[] openSet = PathReflection.getOpenSet(path);
        PathPoint[] closedSet = PathReflection.getClosedSet(path);
        NBTTagList ps = new NBTTagList();
        assert (points != null);
        for (PathPoint p : points) {
            ps.func_74742_a((NBTBase)Server.writePathPoint(p));
        }
        nbt.func_74782_a("ps", (NBTBase)ps);
        NBTTagList op = new NBTTagList();
        assert (openSet != null);
        for (PathPoint p : openSet) {
            op.func_74742_a((NBTBase)Server.writePathPoint(p));
        }
        nbt.func_74782_a("op", (NBTBase)op);
        NBTTagList cp = new NBTTagList();
        assert (closedSet != null);
        for (PathPoint p : closedSet) {
            cp.func_74742_a((NBTBase)Server.writePathPoint(p));
        }
        nbt.func_74782_a("cp", (NBTBase)cp);
        nbt.func_74768_a("ci", PathReflection.getCurrentPathIndex(path));
        return nbt;
    }

    public static void writeString(ByteBuf buffer, String s) {
        byte[] bytes = s.getBytes(StandardCharsets.UTF_8);
        buffer.writeInt(bytes.length);
        buffer.writeBytes(bytes);
    }

    public static void writeWorldInfo(ByteBuf buffer, WorldInfo wi) {
        ByteBufUtils.writeTag((ByteBuf)buffer, (NBTTagCompound)wi.func_76082_a(null));
    }

    static {
        list.add(EnumPacketClient.EYE_BLINK);
        list.add(EnumPacketClient.UPDATE_NPC);
        list.add(EnumPacketClient.SET_TILE_DATA);
        list.add(EnumPacketClient.SEND_FILE_PART);
        list.add(EnumPacketClient.PLAY_SOUND);
        list.add(EnumPacketClient.UPDATE_NPC_ANIMATION);
        list.add(EnumPacketClient.UPDATE_NPC_NAVIGATION);
        list.add(EnumPacketClient.UPDATE_NPC_TARGET);
        list.add(EnumPacketClient.CHAT_BUBBLE);
        list.add(EnumPacketClient.SYNC_ADD);
        list.add(EnumPacketClient.BORDER_DATA);
        list.add(EnumPacketClient.MARCET_DATA);
        list.add(EnumPacketClient.SYNC_END);
        list.add(EnumPacketClient.SYNC_UPDATE);
        list.add(EnumPacketClient.NPC_MOVING_PATH);
        list.add(EnumPacketClient.VISIBLE_TRUE);
        list.add(EnumPacketClient.VISIBLE_FALSE);
        list.add(EnumPacketClient.NPC_DATA);
        list.add(EnumPacketClient.NPC_VISUAL_DATA);
        list.add(EnumPacketClient.FORCE_PLAY_SOUND);
        list.add(EnumPacketClient.NPC_LOOK_POS);
        list.add(EnumPacketClient.UPDATE_HUD);
        list.add(EnumPacketClient.ANIMATION_DATA_SET);
        list.add(EnumPacketClient.ANIMATION_DATA_BASE_ANIMATIONS);
        list.add(EnumPacketClient.ANIMATION_DATA_RUN_ANIMATION);
        list.add(EnumPacketClient.ANIMATION_DATA_STOP_ANIMATION);
        list.add(EnumPacketClient.ANIMATION_DATA_STOP_EMOTION);
        list.add(EnumPacketClient.SCRIPT_CONSOLE);
        list.add(EnumPacketClient.SCRIPT_CODE);
        list.add(EnumPacketClient.GUI);
        list.add(EnumPacketClient.GUI_DATA);
        list.add(EnumPacketClient.SCROLL_DATA);
        list.add(EnumPacketClient.SCROLL_SELECTED);
        list.add(EnumPacketClient.EDIT_NPC);
    }
}

